<?php
// REST endpoint pro systémové informace pro ZiziCache plugin
add_action('rest_api_init', function() {
    register_rest_route('zizi-cache/v1', '/system/info', [
        'methods' => 'GET',
        'callback' => 'zizi_cache_get_system_info',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ]);
});

function zizi_cache_get_system_info($request) {
    global $wpdb;
    $db_server_info = $wpdb->get_var("SELECT VERSION() as version");
    $db_type = 'MySQL';
    if (stripos($db_server_info, 'mariadb') !== false) {
        $db_type = 'MariaDB';
    }

    // Zjistit, zda je aktivní object-cache.php a funkce wp_cache_flush
    $object_cache_active = (function_exists('wp_cache_flush') && file_exists(WP_CONTENT_DIR . '/object-cache.php'));

    return [
        'server_arch' => php_uname('m'),
        'web_server' => $_SERVER['SERVER_SOFTWARE'] ?? '',
        'php_version' => PHP_VERSION,
        'php_sapi' => php_sapi_name(),
        'php_max_input_vars' => ini_get('max_input_vars'),
        'php_time_limit' => ini_get('max_execution_time'),
        'php_memory_limit' => ini_get('memory_limit'),
        'php_max_input_time' => ini_get('max_input_time'),
        'php_upload_max_filesize' => ini_get('upload_max_filesize'),
        'php_post_max_size' => ini_get('post_max_size'),
        'wp_memory_limit' => defined('WP_MEMORY_LIMIT') ? WP_MEMORY_LIMIT : '',
        'wp_max_memory_limit' => defined('WP_MAX_MEMORY_LIMIT') ? WP_MAX_MEMORY_LIMIT : '',
        'db_type' => $db_type,
        'db_version' => $wpdb->db_version(),
        'object_cache_active' => $object_cache_active,
    ];
}
