/**
 * ZiziCache Admin Application
 * 
 * Používá officiální @wordpress/scripts pro sestavení a integraci s WordPress
 * Komponenty jsou renderovány do kontejneru #zizi-cache-admin-app
 * Lokalizovaná data a API URL jsou předávány do aplikace přes window.ziziCacheData
 */
import { createApp } from 'vue'
import App from './App.vue'
import './main.css'

// Import our custom i18n helpers
import { __, forceEnglish } from './i18n'

// Dynamický import preline pouze v prohlížeči - optimalizovaný
if (typeof window !== 'undefined') {
  // Načteme preline až po načtení stránky s lazy loading
  const loadPreline = () => {
    import(/* webpackChunkName: "preline-ui" */ 'preline/dist/preline.js').catch(err => {
      console.warn('Failed to load Preline library:', err);
    });
  };
  
  // Lazy load Preline when needed
  if (document.readyState === 'loading') {
    window.addEventListener('DOMContentLoaded', loadPreline);
  } else {
    loadPreline();
  }
}

// Získání dat z WordPress lokalizace
const ziziData = window.ziziCacheData || {}

// Nastavení REST API URL z lokalizovaných dat nebo fallback
const restUrl = ziziData.restUrl || (window.location.origin + '/wp-json/zizi-cache')

// Vytvoření aplikace s předáním lokalizovaných dat jako props
const app = createApp(App, {
  // Předání WordPress lokalizovaných dat do kořenové komponenty
  wpData: ziziData,
  // Předání REST API URL do kořenové komponenty
  restApiUrl: restUrl
})

// Make translation functions globally available
app.config.globalProperties.__ = __
app.config.globalProperties.forceEnglish = forceEnglish

// Lazy load ApexCharts only when needed
app.config.globalProperties.$loadApexCharts = async () => {
  if (typeof window.ApexChartsLoaded === 'undefined') {
    const VueApexCharts = await import('vue3-apexcharts')
    app.use(VueApexCharts.default)
    window.ApexChartsLoaded = true
  }
}

// Montování aplikace do nového kontejneru
app.mount('#zizi-cache-admin-app')