/**
 * Hard-coded Czech to English translations
 * This is a temporary solution to force English in the admin interface
 */

const translations = {
  // Status strings
  'Povoleno': 'Enabled',
  'Zakázáno': 'Disabled',
  'Chyba': 'Error',
  'Neomezeně': 'Unlimited',
  
  // Time units
  'den': 'day',
  'dny': 'days',
  'dní': 'days',
  'hodina': 'hour',
  'hodiny': 'hours',
  'hodin': 'hours',
  
  // Tab names and section headers
  'Přehled': 'Dashboard',
  'Cache': 'Cache',
  'Databáze': 'Database',
  'OpCache': 'OpCache',
  'ObjectCache': 'ObjectCache',
  'Optimalizace': 'Optimization',
  'CDN': 'CDN',
  'Pokročilé': 'Advanced',
  'Nastavení': 'Settings',
  'Debug': 'Debug',
  'INFO': 'INFO',
  'Pokročilá nastavení': 'Advanced Settings',
  'Rozšířené možnosti a experimentální funkce': 'Advanced options and experimental features',
  
  // Advanced vue component texts
  'Speculative Loading (přednačítání/prerender)': 'Speculative Loading',
  'Režim:': 'Mode:',
  'Vypnuto': 'Off',
  'Prefetch (přednačtení)': 'Prefetch',
  'Prerender (předvykreslení)': 'Prerender',
  'Zvolte, zda chcete stránky pouze přednačítat (prefetch), předvykreslovat (prerender), nebo funkci vypnout.': 
    'Choose whether to prefetch pages, prerender them, or turn off this feature.',
  'Eagerness (agresivita):': 'Eagerness:',
  'Auto (dle WP)': 'Auto (WP default)',
  'Conservative (nejméně agresivní)': 'Conservative (least aggressive)',
  'Moderate (doporučeno)': 'Moderate (recommended)',
  'Eager (nejagresivnější)': 'Eager (most aggressive)', 
  'Určuje, jak agresivně bude prohlížeč přednačítat/prerenderovat stránky. Doporučujeme "Moderate".': 
    'Determines how aggressively the browser will prefetch/prerender pages. We recommend "Moderate".',
  'Vyloučit URL patterny:': 'Exclude URL patterns:',
  'Zadané patterny budou vyloučeny z prefetch/prerender. Podporuje hvězdičku (*).': 
    'The specified patterns will be excluded from prefetch/prerender. Supports wildcards (*).',
  'Podmíněné spouštění': 'Conditional execution',
  'Aktivovat spekulativní načítání pouze na vybraných typech stránek': 
    'Activate speculative loading only on selected page types',
  'Pokročilé atributy': 'Advanced attributes',
  'Omezit pouze na stejnou doménu': 'Limit to same domain only',
  'Zajišťuje, že spekulativní načítání nebude fungovat na odkazy vedoucí mimo váš web': 
    'Ensures that speculative loading will not work on links leading outside your website',
  'Vyžadovat HTTPS spojení': 'Require HTTPS connection',
  'Spekulativní načítání bude fungovat pouze na HTTPS stránkách': 
    'Speculative loading will only work on HTTPS pages',
  'Použít anonymizaci IP adres': 'Use IP address anonymization',
  'Zvyšuje soukromí uživatelů při spekulativním načítání, doporučeno ponechat zapnuto': 
    'Enhances user privacy during speculative loading, recommended to keep enabled',
  'Ochrana analytiky při prerender': 'Analytics protection during prerender',
  'Zakázat odesílání vybraných metrik při prerenderu': 'Disable sending selected metrics during prerender',
  'Plugin do <head> vloží JS s kontrolou': 'The plugin will insert JS in <head> with a check',
  'visibilityState===\'prerender\'': 'visibilityState===\'prerender\'',
  'a zablokuje odesílání dat pro zadané služby. Guard se aplikuje pouze během prerenderu a nezatíží normální načítání.':
    'and block data transmission for specified services. Guard only applies during prerender and will not affect normal page loading.',
  'Vlastní JS pro guard': 'Custom JS for guard',
  'Vložte JS kód bez &lt;script&gt; tagu': 'Insert JS code without &lt;script&gt; tag',
  'Quicklink (Viewport-based prefetching)': 'Quicklink (Viewport-based prefetching)',
  'Aktivovat Quicklink': 'Activate Quicklink',
  'Prefetch/prerender linky viditelné ve viewportu během idle time. Doplňuje Speculation Rules API.':
    'Prefetch/prerender links visible in viewport during idle time. Complements Speculation Rules API.',
  'Režim Quicklink:': 'Quicklink mode:',
  'Oba (prerender + prefetch)': 'Both (prerender + prefetch)',
  'Určuje, zda chcete stránky pouze přednačítat, předvykreslovat, nebo obojí.': 
    'Determines whether you want to only prefetch pages, prerender them, or both.',
  'Výkonnostní nastavení': 'Performance settings',
  'Limit současných requestů:': 'Concurrent request limit:',
  'Maximální počet současně běžících requestů': 'Maximum number of concurrent requests',
  'Celkový limit requestů:': 'Total request limit:',
  'Maximální počet requestů za jedno načtení stránky': 'Maximum number of requests per page load',
  'Delay před prefetch (ms):': 'Delay before prefetch (ms):',
  'Prodleva před zahájením prefetch': 'Delay before starting prefetch',
  'Timeout pro idle (ms):': 'Timeout for idle (ms):',
  'Maximální doba čekání na idle stav prohlížeče': 'Maximum wait time for browser idle state',
  'Viewport threshold (0-100%):': 'Viewport threshold (0-100%):',
  '% viditelnosti odkazu': '% of link visibility',
  'link okraj': 'link edge',
  'poloviční viditelnost': 'half visibility',
  'plná viditelnost': 'full visibility',
  'Jaká část linku musí být viditelná pro zahájení prefetch': 'How much of the link must be visible to start prefetch',
  'Povolené origins:': 'Allowed origins:',
  'Domény odkud lze prefetchovat. Prázdné = pouze same-origin.': 'Domains from where prefetching is allowed. Empty = same-origin only.',
  'Ignore patterns:': 'Ignore patterns:',
  'URL patterny k vyloučení z quicklink prefetching.': 'URL patterns to exclude from quicklink prefetching.',
  'Síťová omezení': 'Network restrictions',
  'Respektovat Data Saver': 'Respect Data Saver',
  'Vypnout prefetching když má uživatel aktivní Data Saver': 'Disable prefetching when the user has Data Saver active',
  'Minimální rychlost připojení:': 'Minimum connection speed:',
  'Quicklink bude aktivní pouze při tomto nebo rychlejším připojení': 'Quicklink will be active only at this or faster connection',
  'Jakékoliv připojení': 'Any connection',
  
  // Cache component texts
  'Uložit nastavení cache': 'Save cache settings',
  'Ukládání...': 'Saving...',

  // Other common translations
  'Vyloučení z cache': 'Cache exclusions',
  'Nikdy nekešovat tyto URL:': 'Never cache these URLs:',
  'Stránky, které přesně nebo částečně odpovídají zadaným řetězcům, nebudou nikdy kešovány.': 
    'Pages that exactly or partially match the specified strings will never be cached.',
  'Nikdy nekešovat pro tyto cookies:': 'Never cache for these cookies:',
  'Pokud prohlížeč odešle cookie s jedním z těchto názvů, stránka nebude obsloužena z cache.': 
    'If the browser sends a cookie with one of these names, the page will not be served from cache.',
  'Ignorovat tyto query parametry:': 'Ignore these query parameters:',
  'Cache bude ignorovat přítomnost těchto parametrů v URL (např. pro sledování kampaní).': 
    'Cache will ignore the presence of these parameters in the URL (e.g. for campaign tracking).',
  'Kešovat pro tyto query parametry:': 'Cache for these query parameters:',
  'Vytvoří oddělenou cache verzi pro každou unikátní hodnotu těchto parametrů.': 
    'Creates a separate cache version for each unique value of these parameters.',
  'Export / Import konfigurace': 'Export / Import configuration',
  'Exportovat konfiguraci': 'Export configuration',
  'Vložte JSON konfigurace k importu': 'Insert JSON configuration to import',
  'Importovat konfiguraci': 'Import configuration',
  'Uložit pokročilá nastavení': 'Save advanced settings',
  
  // Page types
  'Typy stránek pro spekulativní načítání:': 'Page types for speculative loading:',
  'Výchozí stránka s příspěvky': 'Default posts page',
  'Titulní stránka': 'Front page',
  'Jednotlivé stránky a příspěvky': 'Single pages and posts',
  'Archivy (kategorie, štítky, autoři...)': 'Archives (categories, tags, authors...)',
  'Výsledky vyhledávání': 'Search results',
  'Pokud nevyberete žádný typ, spekulativní načítání bude zcela vypnuto.': 
    'If you don\'t select any type, speculative loading will be completely disabled.',
  'Typy stránek pro Quicklink:': 'Page types for Quicklink:',
  'Pokud nevyberete žádný typ, Quicklink bude zcela vypnut.': 
    'If you don\'t select any type, Quicklink will be completely disabled.',
  
  // Button states
  'Uložit': 'Save',
  'Ukládání...': 'Saving...',
  
  // Messages
  'Pokročilá nastavení úspěšně uložena.': 'Advanced settings saved successfully.',
  'Chyba při ukládání pokročilých nastavení:': 'Error saving advanced settings:',
  'Konfigurace exportována.': 'Configuration exported.',
  'Chyba při exportu konfigurace:': 'Error exporting configuration:',
  'Neplatný JSON.': 'Invalid JSON.',
  'Konfigurace úspěšně importována.': 'Configuration imported successfully.',
  'Chyba při importu konfigurace:': 'Error importing configuration:',
  
  // Pokročilé funkce
  'Pokročilé funkce': 'Advanced features',
  'Vysoká priorita': 'High priority',
  'Použít fetch() místo link[rel=prefetch] pro vyšší prioritu': 'Use fetch() instead of link[rel=prefetch] for higher priority',
  'Blokovat reklamní URL': 'Block ad URLs',
  'Zabránit prefetchování reklam a affiliate URL': 'Prevent prefetching ads and affiliate URLs',
  'Vlastní reklamní patterny:': 'Custom ad patterns:',
  'Vlastní URL vzory pro reklamní blokování (oddělené řádkem)': 'Custom URL patterns for ad blocking (separated by line)'
};

/**
 * Translate Czech text to English
 * @param {string} text Czech text to be translated
 * @returns {string} English translation or the original text if no translation was found
 */
export function translateToEnglish(text) {
  // Non-string input handling
  if (typeof text !== 'string') {
    return text;
  }
  
  // Direct translation lookup
  if (translations.hasOwnProperty(text)) {
    return translations[text];
  }
  
  // Handle formatting of days/hours
  const timeRegex = /^(\d+) (den|dny|dní|hodina|hodiny|hodin)$/;
  const timeMatch = text.match(timeRegex);
  if (timeMatch) {
    const number = timeMatch[1];
    const unit = translations[timeMatch[2]];
    return `${number} ${unit}`;
  }
  
  // Return original text if no translation found
  return text;
}

export default translateToEnglish;
