<?php
namespace ZiziCache\RestApi;

use ZiziCache\Authority;
use ZiziCache\RestApi\ValidationTrait;

/**
 * Class CDN
 *
 * Handles REST API endpoints for CDN status, cache clearing, and recommended settings.
 *
 * @package ZiziCache\RestApi
 */
class CDN
{
    use ValidationTrait;

    /**
     * Endpoint definitions for CDN operations.
     *
     * @var array
     */    protected static $endpoints = [
        [
            'route' => '/cdn/status',
            'methods' => 'GET',
            'callback' => 'cdn_status',
            'permission_callback' => [Authority::class, 'rest_api_permission_callback'], // CSRF protected
        ],
        [
            'route' => '/cdn/clear-cache',
            'methods' => 'POST',
            'callback' => 'cdn_clear_cache',
            'permission_callback' => [Authority::class, 'rest_api_permission_callback'], // CSRF protected
        ],
        [
            'route' => '/cdn/recommended-settings',
            'methods' => 'GET',
            'callback' => 'cdn_recommended_settings',
            'permission_callback' => [Authority::class, 'rest_api_permission_callback'], // CSRF protected
        ],
    ];

    /**
     * Registers all CDN endpoints under the given namespaces.
     *
     * @param array $namespaces
     * @return void
     */
    public static function register($namespaces)
    {
        foreach ($namespaces as $namespace) {
            foreach (self::$endpoints as $def) {
                register_rest_route($namespace, $def['route'] . '/?', [
                    'methods' => $def['methods'],
                    'callback' => [__CLASS__, $def['callback']],
                    'permission_callback' => $def['permission_callback'],
                ]);
            }
        }
    }

    /**
     * Returns the CDN status.
     *
     * @return \WP_REST_Response
     */
    public static function cdn_status()
    {
        // Implement according to the original logic (placeholder here)
        return rest_ensure_response(['status' => 'ok']);
    }

    /**
     * Clears the CDN cache.
     *
     * @return \WP_REST_Response
     */
    public static function cdn_clear_cache()
    {
        // Implement according to the original logic (placeholder here)
        return rest_ensure_response(['success' => true]);
    }

    /**
     * Returns recommended CDN settings.
     *
     * @return \WP_REST_Response
     */
    public static function cdn_recommended_settings()
    {
        // Implement according to the original logic (placeholder here)
        return rest_ensure_response(['recommended' => true]);
    }
}
