<?php
/**
 * Plugin integrations registration
 *
 * This file serves as a central configuration point for all plugin integrations.
 * It registers each available integration with the PluginManager, which will
 * handle initialization for those that are active.
 *
 * This design pattern allows for:
 * 1. Easy addition and removal of integrations
 * 2. Centralized management of plugin dependencies
 * 3. Performance optimization by only loading active integrations
 *
 * @package ZiziCache\Plugins
 * @author ZiziCache Team
 * @since 0.2.0
 */

// Import the PluginManager class
use ZiziCache\Plugins\PluginManager;

// Register all available integrations (automatically generated based on Integrations/ directory)
PluginManager::register('ZiziCache\\Plugins\\Integrations\\ACF');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\APO');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\BuddyBoss');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\EWWW');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\Gutenberg');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\NginxHelper');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\PageBuilders');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\Perfmatters');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\Polylang');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\PrettyLinks');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\ShortPixelAI');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\SiteGround');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\TranslatePress');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\Varnish');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\WCML');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\WeGlot');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\WooCommerce');
PluginManager::register('ZiziCache\\Plugins\\Integrations\\WPML');

// Initialize all available integrations on the WordPress init hook for optimal timing
add_action('init', ['ZiziCache\\Plugins\\PluginManager', 'initAll']);
