<?php

namespace ZiziCache;

use ZiziCache\HostProviders\HostProviders;

/**
 * Handles initialization of all integrations for ZiziCache.
 *
 * This class is responsible for initializing integrations with host providers,
 * plugin integrations, and other plugin-specific integrations.
 *
 * @package ZiziCache
 */
class Integrations
{
    /**
     * Initialize all integrations for ZiziCache.
     *
     * Calls the initialization methods for host providers, plugin integrations,
     * and other plugin-specific integrations.
     *
     * @return void
     */
    public static function init()
    {
        // All integrations moved to Plugins\PluginIntegrations
        HostProviders::init();
        Plugins\PluginIntegrations::init();
        Plugins::init();
    }
}
