/**
 * Preline UI ApexCharts helpers
 * Adaptováno pro potřeby ZiziCache
 */

// Funkce pro vytvoření grafu
function buildChart(selector, chartBuilder, lightModeOptions = {}, darkModeOptions = {}) {
  const $chartElement = document.querySelector(selector);
  if (!$chartElement) return;

  const getMode = () => {
    return document.documentElement.classList.contains('dark') ? 'dark' : 'light';
  };

  const getModeOptions = (mode) => {
    return mode === 'dark' ? darkModeOptions : lightModeOptions;
  };

  const initChart = () => {
    const mode = getMode();
    const options = chartBuilder(mode);

    if ($chartElement.chart) {
      $chartElement.chart.destroy();
    }

    $chartElement.chart = new ApexCharts($chartElement, {
      ...options,
      ...(getModeOptions(mode)),
      theme: {
        mode: mode
      }
    });
    $chartElement.chart.render();
  };

  // Inicializace grafu
  initChart();

  // Přidání event listeneru pro změnu tématu
  window.addEventListener('resize', () => {
    setTimeout(() => {
      initChart();
    }, 250);
  });

  // Reaguj na přepínání světlého/tmavého režimu
  document.addEventListener('hs_theme_changed', initChart);
}

// Funkce pro vytvoření tooltipů
function buildTooltip(props, options) {
  const { series, seriesIndex, dataPointIndex } = props;
  const { title, mode, hasTextLabel, wrapperExtClasses, labelDivider, labelExtClasses } = options;

  const value = series[seriesIndex][dataPointIndex];
  const label = props.w.globals.seriesNames[seriesIndex];
  const color = props.w.globals.colors[seriesIndex];

  const wrapperClasses = `flex items-center justify-center gap-2 bg-white dark:bg-neutral-800 border border-gray-200 dark:border-neutral-700 rounded-md py-1.5 px-2 ${wrapperExtClasses || ''}`;
  const labelClasses = `text-[13px] text-gray-500 dark:text-neutral-400 ${labelExtClasses || ''}`;

  return `
    <div class="${wrapperClasses}">
      <div>
        <span class="block text-[13px] font-semibold text-gray-800 dark:text-neutral-200">${title}</span>
        <div class="flex items-center gap-2 mt-1">
          <span class="size-3 inline-block bg-[${color}] rounded-sm"></span>
          <span class="${labelClasses}">${label}${hasTextLabel ? labelDivider : ''} ${hasTextLabel ? value : ''}</span>
        </div>
      </div>
    </div>
  `;
}

// Export funkcí pro použití
window.buildChart = buildChart;
window.buildTooltip = buildTooltip;
