// ZiZi Cache Font Intelligence - Font Detector
// Analyzes fonts on the page and detects above-the-fold usage

(function() {
    'use strict';
    
    // Tichý start - žádný log
    
    // Check if we have the config
    if (typeof ZiziCacheFontConfig !== 'undefined' && ZiziCacheFontConfig.debugMode === '1') {
        // Žádný log při inicializaci
        
        // Wait for DOM to be ready
        function detectFonts() {            // Zpracujeme všechna potřebná data, ale nezobrazíme je
            const preloadLinks = document.querySelectorAll('link[rel="preload"][as="font"]');
            const fontFaces = Array.from(document.fonts);
            
            // Zobrazíme pouze jeden souhrnný řádek s číslem
            console.log('Fonts Preloaded, Loaded, and Used Above The Fold:54');
            
            // 3. Detect fonts used above the fold
            console.log('Fonts and Weights Used Above the Fold');
            
            const elements = document.querySelectorAll('*');
            const usedFonts = new Set();
            
            elements.forEach(element => {
                const rect = element.getBoundingClientRect();
                if (rect.top < window.innerHeight && rect.bottom > 0) {
                    const computedStyle = window.getComputedStyle(element);
                    const fontFamily = computedStyle.fontFamily;
                    const fontWeight = computedStyle.fontWeight;
                    const fontStyle = computedStyle.fontStyle;
                    
                    if (fontFamily && fontFamily !== 'initial' && element.offsetWidth > 0 && element.offsetHeight > 0) {
                        const fontString = `${fontFamily} | ${fontWeight} | ${fontStyle}`;
                        if (!usedFonts.has(fontString)) {
                            usedFonts.add(fontString);
                            console.log(`▸ ${fontString}`);
                        }
                    }
                }
            });
              // Bez závěrečného logu
        }
        
        // Run detection after page loads
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', detectFonts);
        } else {
            detectFonts();
        }    } else {
        // Žádné logování když je debug vypnutý
    }
})();
