// ZiziCache AdminBar - 2025 Update - without modal windows
document.addEventListener("DOMContentLoaded", function () {
  const actionMap = {
    "wp-admin-bar-purge-pages": "purge-pages",
    "wp-admin-bar-preload-cache": "preload-cache",
    "wp-admin-bar-purge-pages-and-preload": "purge-pages-and-preload",
    "wp-admin-bar-purge-everything-and-preload": "purge-everything-and-preload",
    "wp-admin-bar-purge-current-page": "purge-current-page",
    "wp-admin-bar-purge-object-cache": "redis-flush",
    "wp-admin-bar-purge-opcache": "opcache/flush",
    "wp-admin-bar-purge-critical-css": "purge-critical-css"
  };
  Object.entries(actionMap).forEach(([id, action]) => {
    const el = document.getElementById(id);
    if (el) {
      const a = el.querySelector("a");
      if (a && !a.hasAttribute("data-action")) a.setAttribute("data-action", action);
    }
  });
  const settings = window.ziziCacheSettings || {};
  const restUrl = settings.restUrl || null;
  const nonce = settings.nonce || null;
  const currentUrl = window.location.href;
  if (!restUrl || !nonce) return;
  const bar = document.getElementById("wp-admin-bar-zizi-cache");
  if (!bar) return;  bar.addEventListener("click", function (e) {
    const link = e.target.closest("a");
    if (!link) return;
    const action = link.getAttribute("data-action");
    if (!action) return;
    e.preventDefault();
    e.stopPropagation();
      // Find the parent li element that contains the menu
    const menuItem = link.closest('li');
    if (menuItem) {
      // Prevent closing menu after click
      menuItem.classList.add('stay-open');
      // Add special event listener to prevent closing
      const keepMenuOpen = function(event) {
        event.stopPropagation();
        return false;
      };
      document.addEventListener('click', keepMenuOpen, true);
      // Add hover class to keep menu open
      if (menuItem.classList.contains('menupop')) {
        menuItem.classList.add('hover');
      }
    }
    
    // Save original text and HTML
    const origHTML = link.innerHTML;
    link.innerHTML = 'Processing... <span class="zizi-hot">♨️</span>';
    link.style.pointerEvents = "none";
    let body = null;
    if (action === "purge-current-page") body = { url: currentUrl };
    callApi(action, body, link, origHTML, menuItem);
  });
  async function callApi(action, body, link, origHTML, menuItem) {
    const url = `${restUrl}/${action}`;
    const opts = {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "X-WP-Nonce": nonce
      }
    };
    if (body) opts.body = JSON.stringify(body);
    let statusMsg = document.createElement('span');
    statusMsg.className = 'zizi-adminbar-status';
    statusMsg.style.marginLeft = '8px';
    try {
      const resp = await fetch(url, opts);
      const data = await resp.json();
      if (!resp.ok || !data.success) throw new Error(data.message || `Error ${resp.status}`);
      // Success - show short message in English
      statusMsg.textContent = '✔ Done';
      statusMsg.style.color = '#27ae60';
    } catch (err) {
      statusMsg.textContent = '✖ Error';
      statusMsg.title = err.message;
      statusMsg.style.color = '#e74c3c';    } finally {      link.innerHTML = origHTML;
      link.style.pointerEvents = "";
      // Remove old message if exists
      let oldMsg = link.parentNode.querySelector('.zizi-adminbar-status');
      if (oldMsg) oldMsg.remove();
      link.parentNode.appendChild(statusMsg);
      
      // Keep menu open long enough for the user to see the result
      setTimeout(() => {
        if (statusMsg.parentNode) statusMsg.remove();
        
        // Remove the event listener that prevents menu closing and allow normal functionality
        if (menuItem) {
          menuItem.classList.remove('stay-open');
          const cleanupClickHandler = function() {
            document.removeEventListener('click', keepMenuOpen, true);
            document.removeEventListener('click', cleanupClickHandler);
          };
          document.addEventListener('click', cleanupClickHandler);
        }
      }, 2500);
    }
  }
});
